package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.custom.TareaCustomDao;
import com.ejie.ab04b.model.Tarea;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0490s00ServiceImpl generated by UDA, 06-Feb-2017 12:46:17.
 * 
 * @author UDA
 */

@Service(value = "ab0490s00Service")
public class TareaServiceImpl implements TareaService {

	@Autowired()
	private TareaCustomDao ab0490s00Dao;

	/**
	 * Inserts a single row in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  Ab0490s00
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @return the tarea
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tarea add(Tarea ab0490s00) {
		return this.ab0490s00Dao.add(ab0490s00);
	}

	/**
	 * Updates a single row in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  Ab0490s00
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @return the tarea
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tarea update(Tarea ab0490s00) {
		return this.ab0490s00Dao.update(ab0490s00);
	}

	/**
	 * Finds a single row in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  Ab0490s00
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @return the tarea
	 */
	public Tarea find(Tarea ab0490s00) {
		return (Tarea) this.ab0490s00Dao.vfind(ab0490s00);
	}

	/**
	 * Finds a single row in the Ab0490s00 table.
	 * 
	 *  taskId
	 *            String
	 *  procedureId
	 *            String
	 *  Ab0490s00
	 *
	 * @param taskId the task id
	 * @param procedureId the procedure id
	 * @return the tarea
	 */
	public Tarea findByTaskIdProcedureId(String taskId, String procedureId) {
		return (Tarea) this.ab0490s00Dao.findByTaskIdProcedureId(taskId,
				procedureId);
	}

	/**
	 * Deletes a single row in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tarea ab0490s00) {
		this.ab0490s00Dao.remove(ab0490s00);
	}

	/**
	 * Finds a list of rows in the Ab0490s00 table.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0490s00>
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Tarea> findAll(Tarea ab0490s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Tarea>) this.ab0490s00Dao.vfindAll(ab0490s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0490s00 table using like.
	 * 
	 *  ab0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0490s00>
	 *
	 * @param ab0490s00 the ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Tarea> findAllLike(Tarea ab0490s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Tarea>) this.ab0490s00Dao.findAllLike(ab0490s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0490s00 table.
	 * 
	 *  filterAb0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0490s00>
	 *
	 * @param filterAb0490s00 the filter ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Tarea> filter(Tarea filterAb0490s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Tarea> listaAb0490s00 = this.ab0490s00Dao
				.findAllLike(filterAb0490s00, jqGridRequestDto, false);
		Long recordNum = this.ab0490s00Dao.findAllLikeCount(
				filterAb0490s00 != null ? filterAb0490s00 : new Tarea(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Tarea>> reorderSelection = this.ab0490s00Dao
					.reorderSelection(filterAb0490s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Tarea>(jqGridRequestDto, recordNum,
					listaAb0490s00, reorderSelection);
		}
		return new JQGridResponseDto<Tarea>(jqGridRequestDto, recordNum,
				listaAb0490s00);
	}

	/**
	 * Searches rows in the Ab0490s00 table.
	 * 
	 *  filterAb0490s00
	 *            Ab0490s00
	 *  searchAb0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0490s00>>
	 *
	 * @param filterAb0490s00 the filter ab 0490 s 00
	 * @param searchAb0490s00 the search ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Tarea>> search(Tarea filterAb0490s00,
			Tarea searchAb0490s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0490s00Dao.search(filterAb0490s00, searchAb0490s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0490s00 table.
	 * 
	 *  filterAb0490s00
	 *            Ab0490s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0490s00 the filter ab 0490 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Tarea filterAb0490s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0490s00Dao.reorderSelection(filterAb0490s00,
				jqGridRequestDto, startsWith);
	}

}
